
<!-- README.md is generated from README.Rmd. Please edit that file -->

# ecocomDP

<!-- badges: start -->

[![Travis-CI Build
Status](https://travis-ci.com/EDIorg/ecocomDP.svg?branch=master)](https://travis-ci.org/EDIorg/ecocomDP)
[![codecov.io](https://codecov.io/github/EDIorg/ecocomDP/coverage.svg?branch=master)](https://codecov.io/github/EDIorg/ecocomDP?branch=master)
<!-- badges: end -->

## Overview

Tools to create, use, and convert ‘ecocomDP’ datasets. ‘ecocomDP’ is a
dataset design pattern for harmonizing ecological community surveys in a
research question agnostic format, from source datasets published across
multiple repositories, and with methods that keep the derived datasets
up-to-date as the underlying sources change.

## Installation

Get the latest CRAN release:

``` r
install.packages("ecocomDP")
```

Get the latest development version:

``` r
# install.packages("remotes")
remotes::install_github("EDIorg/ecocomDP")
```

## Usage

  - [Create ecocomDP
    datasets](https://ediorg.github.io/ecocomDP/articles/create.html)
  - [Use ecocomDP
    datasets](https://ediorg.github.io/ecocomDP/articles/use.html)
  - [Convert ecocomDP datasets to another model
    format](https://ediorg.github.io/ecocomDP/articles/convert.html)

## Getting help

Use [GitHub Issues](https://github.com/EDIorg/ecocomDP/issues) for bug
reporting, feature requests, and general questions/discussions. When
filing bug reports, please include a minimal reproducible example.

## Contributing

Community contributions are welcome\! Please reference our [contributing
guidelines](https://github.com/EDIorg/ecocomDP/blob/master/CONTRIBUTING.md)
for details.

-----

Please note that this project is released with a [Contributor Code of
Conduct](https://github.com/EDIorg/ecocomDP/blob/master/CODE_OF_CONDUCT.md).
By participating in this project you agree to abide by its terms.
