% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.plugjs}
\alias{ec.plugjs}
\title{Install Javascript plugin from URL source}
\usage{
ec.plugjs(wt = NULL, source = NULL, ask = FALSE)
}
\arguments{
\item{wt}{A widget to add dependency to, see \link[htmlwidgets]{createWidget}}

\item{source}{URL or file:// of a Javascript plugin, \cr
file name suffix is '.js'. Default is NULL.}

\item{ask}{Boolean, to ask the user to download source if missing. Default is FALSE.}
}
\value{
A widget with JS dependency added if successful, otherwise input wt
}
\description{
Install Javascript plugin from URL source
}
\details{
When \emph{source} is URL, the plugin file is installed with an optional popup prompt.\cr
When \emph{source} is a file name (file://xxx.js), it is assumed installed and only a dependency is added.\cr
When \emph{source} is invalid, an error message will be written in the chart's title.\cr
Called internally by \link{ec.init}. It is recommended to use \emph{ec.init(load=...)} instead of \emph{ec.plugjs}.
}
\examples{
# import map plugin and display two (lon,lat) locations
if (interactive()) {
  durl <- paste0('https://raw.githubusercontent.com/apache/echarts/',
           'master/test/data/map/js/china-contour.js')
  ec.init(  # load= durl,
    geo = list(map= 'china-contour', roam= TRUE),
    series.param = list(
      type= 'scatter', coordinateSystem= 'geo',
      symbolSize= 9, itemStyle= list(color= 'red'),
      data= list(list(value= c(113, 40)), list(value= c(118, 39))) )
  ) |> 
  ec.plugjs(durl)
}
}
