% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{-- Introduction --}
\alias{-- Introduction --}
\title{Introduction}
\description{
echarty provides a lean interface between R and Javascript library ECharts.\cr
With only two major commands (\emph{ec.init} and \emph{ec.upd}), it can trigger multiple native ECharts options to build a chart. \cr
The benefits - learn a very limited set of commands, and enjoy the \strong{full functionality} of ECharts.
}
\section{Package Conventions}{
\enumerate{
\item pipe-friendly - supports both \%>\% and |>
\item commands have three prefixes to help with auto-completion:
}
\itemize{
\item \emph{ec.} for general functions, like \link{ec.init}
\item \emph{ecs.} for Shiny functions, like \link{ecs.output}
\item \emph{ecr.} for rendering functions, like \link{ecr.band}
}
}

\section{Global Options}{
Options are set with R command
\href{https://www.rdocumentation.org/packages/base/versions/3.6.2/topics/options}{options}.
Echarty uses the following options:
\itemize{
\item echarty.theme = name of theme file, without extension, from folder
/inst/themes
\item echarty.font = font family name
\item echarty.urlTiles = tiles URL template for leaflet maps
}
}

\section{Events}{
Event handling is usually necessary only in Shiny. See code in
\link{ec.examples} and \code{eshiny.R}, run as \code{demo(eshiny)}.\if{html}{\out{<br>}}
echarty has two built-in event callbacks - \code{click} and \code{mouseover}. \if{html}{\out{<br>}}
All other ECharts
\href{https://echarts.apache.org/en/api.html#events}{events} should be
initialized through \code{p$x$capture}. Another option is to use \code{p$x$on}
with JavaScript handlers, see code in \link{ec.examples}.
}

\section{Widget ‘x’ parameters}{
These are \code{htmlwidget} and \code{ECharts} initialization parameters supported
by echarty. There are code samples for most of them in
\link{ec.examples}.
\itemize{
\item capture = event name(s), to monitor events, usually in Shiny
\item on = define JavaScript code for event handling, see it in
\href{https://echarts.apache.org/en/api.html#echartsInstance.on}{ECharts}
\item registerMap = define a map from a geoJSON file, see it in
\href{https://echarts.apache.org/en/api.html#echarts.registerMap}{ECharts}
\item group = group-name of a chart, see it in
\href{https://echarts.apache.org/en/api.html#echartsInstance.group}{ECharts}
\item connect = command to connect charts with same group-name, see it in
\href{https://echarts.apache.org/en/api.html#echarts.connect}{ECharts}
\item locale = ‘EN’(default) or ‘ZH’, set from \code{locale} parameter of
\link{ec.init}, see it in
\href{https://echarts.apache.org/en/api.html#echarts.init}{ECharts}.
\item renderer = ‘canvas’(default) or \code{svg}, set from \code{renderer} in
\link{ec.init}, see it in
\href{https://echarts.apache.org/en/api.html#echarts.init}{ECharts}.
\item jcode = custom JavaScript code to execute, set from \code{js} parameter of
\link{ec.init}
}
}

\section{R vs Javascript numbering}{
R indexes are counted starting from 1.
JS indexes are counted starting from 0.
echarty supports R-counting in series-encode \strong{x,y,tooltip} and
visualMap-continuous \strong{dimension} when set through \emph{ec.init}. All other
indexes like \emph{xAxisIndex}, \emph{gridIndex}, etc. need to be set in
JS-counting (for now).
}

\section{Code examples}{
Here is the complete list of sample code \strong{locations}
\itemize{
\item \link{ec.examples}
\item command examples, like in \link{ec.init}
\item Shiny code is in \code{eshiny.R}, run with \code{demo(eshiny)}
\item website \href{https://helgasoft.github.io/echarty/gallery.html}{gallery}
and \href{https://helgasoft.github.io/echarty/}{tutorials}
\item searchable \href{https://gist.github.com/helgasoft}{gists}
\item demos on \href{https://rpubs.com/echarty}{RPubs}
\item answers to \href{https://github.com/helgasoft/echarty/issues}{Github issues}
\item code in \href{https://github.com/helgasoft/echarty/tree/main/tests/testthat}{Github tests}
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# basic scatter chart from a data.frame, using presets
cars |> ec.init()

# set/get global options
options('echarty.theme'='jazz') # set
getOption('echarty.theme')      # get
options('echarty.theme'=NULL)   # remove
}\if{html}{\out{</div>}}
}

