% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_sankey}
\alias{e_sankey}
\alias{e_sankey_}
\title{Sankey}
\usage{
e_sankey(
  e,
  source,
  target,
  value,
  layout = "none",
  rm_x = TRUE,
  rm_y = TRUE,
  ...
)

e_sankey_(
  e,
  source,
  target,
  value,
  layout = "none",
  rm_x = TRUE,
  rm_y = TRUE,
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{source, target}{Source and target columns.}

\item{value}{Value change from \code{source} to \code{target}.}

\item{layout}{Layout of sankey.}

\item{rm_x, rm_y}{Whether to remove the x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Draw a sankey diagram.
}
\examples{
sankey <- data.frame(
  source = c("a", "b", "c", "d", "c"),
  target = c("b", "c", "d", "e", "e"),
  value = ceiling(rnorm(5, 10, 1)),
  stringsAsFactors = FALSE
)

sankey \%>\%
  e_charts() \%>\%
  e_sankey(source, target, value)
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-sankey}{Additional arguments}
}
