% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-polyfit-option-method.R
\name{ecop.polyfit_option}
\alias{ecop.polyfit_option}
\title{Poly fit on option prices}
\usage{
ecop.polyfit_option(k, V, k.cusp, k.new, degree.left = 6, degree.right = 6)
}
\arguments{
\item{k}{numeric, vector of log-strike}

\item{V}{numeric, vectors of option prices}

\item{k.cusp}{length-one numeric, the suggested cusp location}

\item{k.new}{numeric, vector of log-strike to evaluate the poly fit}

\item{degree.left}{length-one numeric, specifying the degree of poly fit for the left tail}

\item{degree.right}{length-one numeric, specifying the degree of poly fit for the right tail}
}
\value{
The state prices from the poly fit
}
\description{
The poly fits on logarithm of option prices are performed for each side 
of the suggested cusp (specified by \code{k.cusp}).
This utiility is used mainly to remove the market data noise for 
the calculation of log-slope of option prices.
}
\author{
Stephen H-T. Lihn
}
\keyword{ecop}
