% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-data-method.R
\name{ecd.data}
\alias{ecd.data}
\alias{ecd.data.arr}
\alias{ecd.data.ts}
\title{Read sample data}
\usage{
ecd.data(symbol = "dji")

ecd.data.arr(symbol = "dji", start.date = "1950-01-01",
  end.date = "2015-12-31", on = "days", lag = 1, drop = 0,
  repeated = TRUE, cache = TRUE, do.kurtosis = FALSE)

ecd.data.ts(ts, start.date = "1950-01-01", end.date = "2015-12-31",
  on = "days", lag = 1, drop = 0, repeated = TRUE,
  do.kurtosis = FALSE)
}
\arguments{
\item{symbol}{character, the symbol of the time series. Default: dji}

\item{start.date, end.date}{Date or character of ISO format (YYYY-MM-DD), to specify the date range, 
default is from 1950-01-01 to 2015-12-31. 
Set start.date and end.date to NULL or "" if you wish to get the entire time series.}

\item{on}{character, specify the calendar interval, days, weeks, months. Default is \code{days}.}

\item{lag}{integer, specify the lags of return calculation, default is 1.}

\item{drop}{integer, specify number of largest outliners to drop, default is 0.}

\item{repeated}{logical, specify whether to use repeated sampling or unique sampling, default is \code{TRUE}.
Using "repeated" sampling can reduce noise due to insufficient sample size. This is particularly useful for larger lags.}

\item{cache}{logical, use R's options memory to cache xts data, default is \code{TRUE}.}

\item{do.kurtosis}{logical, if specified, calculate mean, sd, var, skewness, and kurtosis, default is \code{FALSE}.}

\item{ts}{xts, the time series}
}
\value{
\code{ecd.data} returns an xts object for the time series, with two columns - "Close" and "logr".
        \code{ecd.data.arr} and \code{ecd.data.ts} return a list of three vectors: x is the log-return, p is the prices, and d is the dates.
}
\description{
Read sample data by specifying the symbol. The two utilities, \code{ecd.data} and \code{ecd.data.arr},
serves for slightly different purpose. 
\code{ecd.data} works off the xts object that has two rows: 
the prices and log-returns indexed by the dates. 
\code{ecd.data.arr} and \code{ecd.data.ts} separate the data into list of three vectors: x is the log-return, p is the prices, and d is the dates.
And allows for more sophisticated call for range of dates, and different ways of slice and lag.
\code{ecd.data.arr} takes symbol as input, while \code{ecd.data.ts} takes an xts object.
}
\examples{
dji <- ecd.data()
wti <- ecd.data("wti")
spx <- ecd.data.arr("spx", lag=5)
}
\keyword{sample-data}
\keyword{timeseries}
\keyword{xts}
