% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-distribution-method.R
\name{dec}
\alias{dec}
\alias{pec}
\alias{qec}
\alias{rec}
\title{The Elliptic Distribution}
\usage{
dec(x, object = ecd())

pec(q, object = ecd())

qec(p, object = ecd(with.quantile = TRUE), debug = FALSE)

rec(n, object = ecd(with.quantile = TRUE))
}
\arguments{
\item{x}{numeric vector of quantiles.}

\item{object}{an object of ecd class. 
To achieve high performance for \code{qec} and \code{rec}, 
it should be created with \code{with.quantile=TRUE}.}

\item{q}{numeric vector of quantiles.}

\item{p}{numeric vector of probabilities.}

\item{debug}{logical, whether to print debug message, default is \code{FALSE}.}

\item{n}{number of observations.}
}
\value{
\code{dec} gives the density,
\code{pec} gives the distribution function, 
\code{qec} gives the quantile function, 
\code{rec} generates random deviates.
}
\description{
Density, distribution function, quantile function, 
and random generation for the univariate elliptic distribution.
}
\examples{
d <- ecd(with.quantile=TRUE)
x <- seq(-20, 20, by=5)
dec(x,d)
pec(x,d)
p <- c(0.0001, 0.001, 0.01, 0.99, 0.999, 0.9999)
qec(p,d)
rec(100,d)
}
\author{
Stephen H. Lihn
}
\keyword{distribution}

