% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdb-constructor.R
\name{ecdb}
\alias{ecdb}
\title{Constructor of ecdb class for the elliptic database}
\usage{
ecdb(file = NULL, newdb = FALSE)
}
\arguments{
\item{file}{Character, the full path to an elliptic database. 
Use "internal" to force the usage of the internal db.}

\item{newdb}{Logical. If \code{TRUE}, remove existing db and create a new one.
Default: \code{FALSE}.}
}
\value{
An object of ecdb class
}
\description{
Construct an ecdb class by providing the required parameters.
The default is to use the internal database location. 
But the internal db is limited in size.
The the elliptic database stores
the stdev, kurtosis, discriminant, j-invariant, and ellipticity.
for alpha and gamma between -100 and 100.
Step size is 1 for -100 to 100; 0.25 for -50 to 50;
0.1 for -10 to 10; 0.025 between -6 and 1.
Speical lines with step size of 0.001 for j0 and j1728 between -10 and 10;
0.01 for kmax and critical between 0 and 100.
For asym1X, step size is 10 from 100 to 1000.
For asym2X, step size is 100 from 1000 to 10000.
For asym3X, step size is 1000 from 10000 to 60000.
For polar-q1, step size is 0.025 from 0 to 20 for log2(R), and integer angles, 0-89.
}
\examples{
db <- ecdb("internal")
}
\keyword{constructor}

