% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_and_leave_one_out.R
\name{boot_probtrans}
\alias{boot_probtrans}
\title{Bootstrap confidence intervals for transition probabilities}
\usage{
boot_probtrans(coxrfx_fits_boot, patient_data, tmat, initial_state, max_time)
}
\arguments{
\item{coxrfx_fits_boot}{The list of CoxRFX objects obtained by running \code{boot_coxrfx}.}

\item{patient_data}{(Single) patient data in `long format`, possibly with `expanded` covariates
(as obtained by running \code{mstate::expand.covs}).}

\item{tmat}{Transition matrix for the multi-state model, as obtained by running \code{mstate::transMat}}

\item{initial_state}{The initial state for which transition probability estimates should be computed}

\item{max_time}{The maximum time for which estimates should be computed}
}
\value{
Interval estimates for transition probabilities.
}
\description{
Generates 95\% highest density bootstrap interval estimates for transition probabilities computed using \code{probtrans_ebmstate} (semi-Markov version).
}
\seealso{
\code{\link{probtrans_ebmstate}}; \code{\link{boot_coxrfx}}; 
\code{\link[mstate:trans]{transMat}}; \code{\link[mstate]{expand.covs}}
}
\author{
Rui Costa
}
