% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_pis}
\alias{plot_pis}
\title{Plot predictor importance (PI) box plots}
\usage{
plot_pis(
  pis,
  ext,
  by_cover_class = TRUE,
  n_top_pred = 15,
  pretty_names = TRUE,
  plot = TRUE
)
}
\arguments{
\item{pis}{data frame; predictor importance data from \code{\link[=load_pis]{load_pis()}}.}

\item{ext}{\link{ebirdst_extent} object; the spatiotemporal extent over which to
calculate PIs. This is required, since results are less meaningful over
large spatiotemporal extents.}

\item{by_cover_class}{logical; whether to aggregate the FRAGSTATS metrics
(PLAND and ED) for the land cover classes into single values for the land
cover classes.}

\item{n_top_pred}{integer; how many predictors to show.}

\item{pretty_names}{logical; whether to convert cryptic land cover codes to
readable land cover class names.}

\item{plot}{logical; whether to plot predictor importance or just return top
predictors.}
}
\value{
Plots a boxplot of predictor importance and invisibly returns the PI
data subset to just the top predictors, grouped and renamed according to
\code{by_cover_class} and \code{pretty_names}.
}
\description{
For a given eBird Status and Trends species, produce a box plot showing the
predictor importance (PI) for each of the predictors used in the occurrence
model. Predictors are plotted in order from highest to lowest importance.
Many function parameters allow for customized plots.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# load predictor importance
pis <- load_pis(path)

# define a spatiotemporal extent to plot data from
bb_vec <- c(xmin = -86, xmax = -83, ymin = 41.5, ymax = 43.5)
e <- ebirdst_extent(bb_vec, t = c("05-01", "05-31"))

top_pred <- plot_pis(pis, ext = e, n_top_pred = 10)
top_pred
}
}
