% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeComplexeBlockExclusion.R
\name{analyzeComplexBlockExclusion}
\alias{analyzeComplexBlockExclusion}
\title{Analyze complex block exclusiveness}
\usage{
analyzeComplexBlockExclusion(
  solverOut_list,
  items_list,
  idCol,
  exclusionTuples_list
)
}
\arguments{
\item{solverOut_list}{List of objects created by \code{useSolver}.}

\item{items_list}{List of original \code{data.frame} containing information on item level.}

\item{idCol}{Column name with item IDs in the \code{items} \code{data.frames}.}

\item{exclusionTuples_list}{List of \code{data.frames} with two columns, containing tuples with item IDs which
should be in test forms exclusively. Must be the same objects as used in \code{\link{itemExclusionConstraint}}.}
}
\value{
A \code{data.frame} of block exclusions.
}
\description{
Use exclusion tuples information from independent test assembly problems to determine which assembled
test blocks are exclusive.
}
\details{
If exclusion tuples have been used to assemble test forms (using the \code{\link{itemExclusionConstraint}}
function), the resulting
item blocks might also be exclusive. Using the initially used item exclusion tuples and the optimal solution
given by \code{useSolver} this function determines, which item blocks are exclusive and can not be together in an
assembled test form. \code{analyzeComplexBlockExclusion} allows analyzing block exclusiveness from separate test
assembly problems. This can be useful if test forms consist of blocks containing different domains or dimensions.
}
\examples{
## Full workflow using itemExclusionTuples
# tbd


}
