% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc.R
\name{check_marker}
\alias{check_marker}
\title{Verify Markers for Specific Clusters Using matchCellMarker}
\usage{
check_marker(
  marker,
  n,
  spc,
  tissueClass = available_tissue_class(spc),
  tissueType = available_tissue_type(spc),
  cl = c(),
  topcellN = 2,
  cis = FALSE
)
}
\arguments{
\item{marker}{A data frame of markers obtained from \code{Seurat::FindAllMarkers}.}

\item{n}{An integer specifying the top number of genes to match from the
input markers.}

\item{spc}{A character string specifying the species, which can be either
'Human' or 'Mouse'.}

\item{tissueClass}{A character specifying the tissue classes, default \code{available_tissue_class(spc)}.}

\item{tissueType}{A character specifying the tissue types, default \code{available_tissue_type(spc)}.}

\item{cl}{An integer or vector of integers specifying the clusters to check.}

\item{topcellN}{An integer specifying the number of top cells to check for
each cluster.}

\item{cis}{A logical value indicating whether to check marker directly from the top symbol of
\code{matchCellMarker2} or re-search marker for top cell in cellMarker2.}
}
\value{
A named list where each name corresponds to a cell type and each
element is a vector of marker names.
}
\description{
This function checks the markers for specified clusters returned by the
\code{matchCellMarker2} function. It allows users to filter by species, cluster,
and to specify whether to consider cis or trans interactions.
}
\examples{
# Example usage:
# Check the top 50 markers for clusters 1, 4, and 7 in the Human species.
\dontrun{
library(easybio)
data(pbmc.markers)
check_marker(pbmc.markers, n = 50, spc = "Human", cl = c(1, 4, 7))
}
}
