% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette.R
\name{palette_filter}
\alias{palette_filter}
\title{color filters for any vector of hex color values}
\usage{
palette_filter(
  palette = palette_qualitative(),
  similar = F,
  greys = T,
  reds = T,
  greens = T,
  blues = T,
  dark = T,
  medium = T,
  bright = T,
  thresh_similar = 25
)
}
\arguments{
\item{palette}{any vector with hex color values, Default: palette_qualitative()}

\item{similar, }{logical, allow similar colours, similar colours are detected using a
threshold (thresh_similar), two colours are similar when each value for RGB
is within threshold range of the corresponding RGB value of the second
colour, Default: F}

\item{greys, }{logical, allow grey colours, blue == green == blue , Default: T}

\item{reds, }{logical, allow red colours, blue < 50 & green < 50  & red > 200 , Default:
T}

\item{greens, }{logical, allow green colours, green > red & green > blue, Default: T}

\item{blues, }{logical, allow blue colours, blue > green & green > red, Default: T}

\item{dark, }{logical, allow colours of dark intensity, sum( red, green, blue) < 420 ,
Default: T}

\item{medium, }{logical, allow colours of medium intensity, between( sum( red, green,
blue), 420, 600) , Default: T}

\item{bright, }{logical, allow colours of bright intensity, sum( red, green, blue) > 600, Default: T}

\item{thresh_similar, }{int, threshold for defining similar colours, see similar, Default: 25}
}
\value{
vector with hex colors
}
\description{
filters are based on rgb values
}
\examples{

require(magrittr)

palette_qualitative() \%>\%
  palette_filter(thresh_similar = 0) \%>\%
  palette_plot_intensity()

\dontrun{
# more examples---------------------------

palette_qualitative() \%>\%
  palette_filter(thresh_similar = 25) \%>\%
  palette_plot_intensity()

palette_qualitative() \%>\%
  palette_filter(thresh_similar = 0, blues = FALSE) \%>\%
  palette_plot_intensity()
}
}
