% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper3D.R
\name{reproduce.track.3d}
\alias{reproduce.track.3d}
\title{Reproduce a track with the eRTG3D}
\usage{
reproduce.track.3d(
  track,
  n.sim = 1,
  parallel = FALSE,
  error = TRUE,
  DEM = NULL,
  BG = NULL,
  filterDeadEnds = TRUE,
  plot2d = FALSE,
  plot3d = FALSE,
  maxBin = 25,
  gradientDensity = TRUE
)
}
\arguments{
\item{track}{data.frame with x,y,z coordinates of the original track}

\item{n.sim}{number of simulations that should be done}

\item{parallel}{logical: run computations in parallel (n-1 cores)? Or numeric: the number of nodes (maximum: n - 1 cores)}

\item{error}{logical: add error term to movement in simulation?}

\item{DEM}{a raster containing a digital elevation model, covering the same extent as the track}

\item{BG}{a raster influencing the probabilities.}

\item{filterDeadEnds}{logical: Remove tracks that ended in a dead end?}

\item{plot2d}{logical: plot tracks on 2-D plane?}

\item{plot3d}{logical: plot tracks in 3-D?}

\item{maxBin}{numeric scalar, maximum number of bins per dimension of the tld-cube (\link[eRTG3D]{turnLiftStepHist})}

\item{gradientDensity}{logical: Should a distribution of the gradient angle be extracted and used in the simulations (\link[eRTG3D]{get.densities.3d})?}
}
\value{
A list or data.frame containing the simulated track(s) (CERW).
}
\description{
Simulates n tracks with the geometrical properties of the original track,
between the same start and end point.
}
\examples{
reproduce.track.3d(niclas[1:10, ])
}
