% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfWrapper3D.R
\name{transformCRS.3d}
\alias{transformCRS.3d}
\title{Transform coordinates reference system (CRS) of a 3-D track}
\usage{
transformCRS.3d(track, fromCRS, toCRS)
}
\arguments{
\item{track}{data.frame with x,y,z coordinates}

\item{fromCRS}{string: proj4 of current CRS}

\item{toCRS}{string: proj4 of CRS to be converted in}
}
\value{
A data.frame containing x,y,z and variables.
}
\description{
Attention: Please use this function for CRS transformations, 
since it is based on the \link[sf]{st_transform} from the sf package and therefore
supports CRS transformations in 3-D. Note: \link[sp]{spTransform} from the \link{sp} package
only supports transformations in the 2D plane, which will cause distortions
in the third dimension.
}
\examples{
transformCRS.3d(niclas, fromCRS="+init=epsg:2056", toCRS="+init=epsg:4326")
}
