% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survCurv.R
\name{plotSurv}
\alias{plotSurv}
\title{Plot Survival Curves (or Cumulative Hazard Function) and their difference}
\usage{
plotSurv(object, legendName = "", conf.int = FALSE, smooth = FALSE,
         lty, col, ...)
}
\arguments{
\item{object}{An object returned by function \code{survCurve} or
\code{survDiff}.}

\item{legendName}{An optional name for the figure legend.}

\item{conf.int}{A logical value indicating whether to plot the credible
interval(s).}

\item{smooth}{A logical value, default \code{FALSE}. If \code{TRUE}, plot
the coefficients as smooth lines; otherwise, plot the coefficients as
piece-wise constant step functions.}

\item{lty}{An optional numeric vector indicating line types specified to
different groups: 0 = blank, 1 = solid, 2 = dashed, 3 = dotted, 4 =
dotdash, 5 = longdash, 6 = twodash.}

\item{col}{An optional character or numeric vector indicating line colors
specified to different groups.}

\item{...}{Other arguments for future usage.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the survival curves (or cumulative hazard) and their difference for
objects returned by function \code{survCurve} or \code{survDiff}.  By using
\code{ggplot2} plotting system, the plots generated are able to be further
customized properly.
}
\examples{
## See the examples in bayesCox.
}
\seealso{
\code{\link{bayesCox}}, \code{\link{survCurve}}, and
\code{\link{survDiff}}.
}
