/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.BaseGradientPainter;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public abstract class WaveDelegateGradientPainter
extends BaseGradientPainter {
    protected String painterName;
    protected ColorSchemeTransformation transformation;
    protected SubstanceGradientPainter delegate;

    public WaveDelegateGradientPainter(String painterName, ColorSchemeTransformation transformation, SubstanceGradientPainter delegate) {
        this.painterName = painterName;
        this.transformation = transformation;
        this.delegate = delegate;
    }

    public String getDisplayName() {
        return this.painterName;
    }

    public BufferedImage getContourBackground(int width, int height, Shape contour, boolean isFocused, ColorScheme colorScheme1, ColorScheme colorScheme2, float cyclePos, boolean hasShine, boolean useCyclePosAsInterpolation) {
        BufferedImage mixResult = this.getMixContourBackground(width, height, contour, isFocused, colorScheme1, colorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
        if (mixResult != null) {
            return mixResult;
        }
        ColorScheme interpolationScheme1 = colorScheme1;
        ColorScheme interpolationScheme2 = useCyclePosAsInterpolation ? colorScheme2 : colorScheme1;
        double cycleCoef = 1.0 - (double)cyclePos / 10.0;
        Color topBorderColor = SubstanceColorUtilities.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        Color midBorderColor = SubstanceColorUtilities.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        Color bottomBorderColor = SubstanceColorUtilities.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        BufferedImage topFullImage = this.delegate.getContourBackground(width, height, contour, isFocused, colorScheme1, colorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
        GeneralPath clipBottom = new GeneralPath();
        clipBottom.moveTo(0.0f, height);
        clipBottom.lineTo(width, height);
        clipBottom.lineTo(width, 0.0f);
        clipBottom.curveTo(5 * width / 6, height / 3, 3 * width / 4, height / 2, width / 2, height / 2);
        clipBottom.curveTo(width / 3, height / 2, width / 4, height, 0.0f, 7 * height / 8);
        clipBottom.lineTo(0.0f, height);
        BufferedImage clipShapeBottom = SubstanceCoreUtilities.createClipImage(clipBottom, width, height);
        BufferedImage bottomImage = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D bottomGraphics = (Graphics2D)bottomImage.getGraphics();
        bottomGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme bottomColorScheme1 = this.transformation == null ? colorScheme1 : this.transformation.transform(colorScheme1);
        ColorScheme bottomColorScheme2 = this.transformation == null ? colorScheme1 : this.transformation.transform(colorScheme2);
        BufferedImage bottomFullImage = this.delegate.getContourBackground(width, height, contour, isFocused, bottomColorScheme1, bottomColorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
        bottomGraphics.setComposite(AlphaComposite.Src);
        bottomGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        bottomGraphics.drawImage((Image)clipShapeBottom, 0, 0, null);
        bottomGraphics.setComposite(AlphaComposite.SrcAtop);
        bottomGraphics.drawImage((Image)bottomFullImage, 0, 0, null);
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setClip(contour);
        graphics.drawImage((Image)topFullImage, 0, 0, null);
        graphics.drawImage((Image)bottomImage, 0, 0, null);
        graphics.setClip(null);
        GradientPaint gradientBorderTop = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
        graphics.setPaint(gradientBorderTop);
        graphics.setClip(0, 0, width, height / 2);
        graphics.draw(contour);
        GradientPaint gradientBorderBottom = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
        graphics.setPaint(gradientBorderBottom);
        graphics.setClip(0, height / 2, width, 1 + height / 2);
        graphics.draw(contour);
        return image;
    }

    public static interface ColorSchemeTransformation {
        public ColorScheme transform(ColorScheme var1);
    }
}

