/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.DonneeID;
import don.DonneeMoyenne;
import don.Groupe;
import don.Modalite;
import don.Nominale;
import exceptions.ExceptionIntegrite;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModaliteMoyenne
extends Modalite
implements DonneeMoyenne {
    private static final long serialVersionUID = 4332798465977843188L;
    private Vector<Modalite> m_branches = new Vector();

    public ModaliteMoyenne(Nominale nominale, String annotation, boolean active, Groupe gr, double[] coord, double[] cos2, double[] contrib, int generation) {
        super(nominale, annotation, active, gr, coord, cos2, contrib, generation);
    }

    public ModaliteMoyenne(Nominale nominale, String annotation) {
        super(nominale, annotation);
    }

    @Override
    public Vector<DonneeID> getBranches() {
        return new Vector<DonneeID>(this.m_branches);
    }

    public Modalite get(int i) {
        return this.m_branches.get(i);
    }

    public void addBranche(Modalite fille) {
        this.m_branches.add(fille);
        if (fille.getPere() == null || !fille.getPere().equals(this)) {
            fille.setPere(this);
        }
    }

    @Override
    public int getNbBranches() {
        return this.m_branches.size();
    }

    @Override
    public void setGeneration(int generation) {
        super.setGeneration(generation);
        for (Modalite mod_fille : this.m_branches) {
            mod_fille.setGeneration(generation + 1);
        }
    }

    public Modalite getModalite(String annot) {
        Modalite trouve = null;
        if (this.getAnnotation().equals(annot)) {
            trouve = this;
        } else {
            int i = 0;
            while (i < this.getNbBranches() && trouve == null) {
                Modalite temp = this.m_branches.elementAt(i);
                if (temp instanceof ModaliteMoyenne) {
                    trouve = ((ModaliteMoyenne)temp).getModalite(annot);
                } else if (temp.getAnnotation().equals(annot)) {
                    trouve = temp;
                }
                ++i;
            }
        }
        return trouve;
    }

    @Override
    public String toString() {
        String chaine = super.toString();
        chaine = String.valueOf(chaine) + "\nenfants : ";
        for (Modalite fille : this.m_branches) {
            chaine = String.valueOf(chaine) + fille.toString() + "\n";
        }
        chaine = String.valueOf(chaine) + "fin modalit\ufffd moyenne\n";
        return chaine;
    }

    @Override
    public void verifierIntegrite() throws ExceptionIntegrite {
        super.verifierIntegrite();
        for (Modalite mod : this.m_branches) {
            mod.verifierIntegrite();
        }
    }
}

