% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_replace_request.R
\name{dataset_replace_request}
\alias{dataset_replace_request}
\title{Create request object for replacing existing datasets.}
\usage{
dataset_replace_request(description = NULL, summary = NULL, tags = NULL,
  license_string = NULL, visibility, files = NULL)
}
\arguments{
\item{description}{(optional) Dataset description.}

\item{summary}{(optional) Dataset summary (markdown supported).}

\item{tags}{(optional) List of dataset tags (letters, numbers and spaces).}

\item{license_string}{Dataset license ("Public Domain", "PDDL", "CC-0",
"CC-BY", "ODC-BY", "CC-BY-SA", "ODC-ODbL", "CC BY-NC-SA" or Other).}

\item{visibility}{Dataset visibility ("PRIVATE" or "OPEN").}

\item{files}{(optional) List of \code{\link{file_create_request}} objects.}
}
\value{
Request object of type \code{dataset_replace_request}.
}
\description{
Create request object for replacing existing datasets.
}
\examples{
dataset_put_req <- dwapi::dataset_replace_request(visibility = 'OPEN',
  description = 'updated description')
}
\seealso{
\code{\link{replace_dataset}}, \code{\link{add_file}}
}
