//===----------------------------------------------------------------------===//
//                         DuckDB
//
// function/aggregate/distributive_functions.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is automatically generated by scripts/generate_functions.py
// Do not edit this file manually, your changes will be overwritten
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/function/function_set.hpp"

namespace duckdb {

struct CountStarFun {
	static constexpr const char *Name = "count_star";
	static constexpr const char *Parameters = "";
	static constexpr const char *Description = "";
	static constexpr const char *Example = "";
	static constexpr const char *Categories = "";

	static AggregateFunction GetFunction();
};

struct CountFun {
	static constexpr const char *Name = "count";
	static constexpr const char *Parameters = "arg";
	static constexpr const char *Description = "Returns the number of non-null values in arg.";
	static constexpr const char *Example = "count(A)";
	static constexpr const char *Categories = "";

	static AggregateFunctionSet GetFunctions();
};

struct FirstFun {
	static constexpr const char *Name = "first";
	static constexpr const char *Parameters = "arg";
	static constexpr const char *Description = "Returns the first value (null or non-null) from arg. This function is affected by ordering.";
	static constexpr const char *Example = "first(A)";
	static constexpr const char *Categories = "";

	static AggregateFunctionSet GetFunctions();
};

struct ArbitraryFun {
	using ALIAS = FirstFun;

	static constexpr const char *Name = "arbitrary";
};

struct LastFun {
	static constexpr const char *Name = "last";
	static constexpr const char *Parameters = "arg";
	static constexpr const char *Description = "Returns the last value of a column. This function is affected by ordering.";
	static constexpr const char *Example = "last(A)";
	static constexpr const char *Categories = "";

	static AggregateFunctionSet GetFunctions();
};

struct AnyValueFun {
	static constexpr const char *Name = "any_value";
	static constexpr const char *Parameters = "arg";
	static constexpr const char *Description = "Returns the first non-null value from arg. This function is affected by ordering.";
	static constexpr const char *Example = "";
	static constexpr const char *Categories = "";

	static AggregateFunctionSet GetFunctions();
};

struct MinFun {
	static constexpr const char *Name = "min";
	static constexpr const char *Parameters = "arg";
	static constexpr const char *Description = "Returns the minimum value present in arg.";
	static constexpr const char *Example = "min(A)";
	static constexpr const char *Categories = "";

	static AggregateFunctionSet GetFunctions();
};

struct MaxFun {
	static constexpr const char *Name = "max";
	static constexpr const char *Parameters = "arg";
	static constexpr const char *Description = "Returns the maximum value present in arg.";
	static constexpr const char *Example = "max(A)";
	static constexpr const char *Categories = "";

	static AggregateFunctionSet GetFunctions();
};

} // namespace duckdb
