% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DISTANCES-sdtw.R
\name{sdtw}
\alias{sdtw}
\title{Soft-DTW distance}
\usage{
sdtw(x, y, gamma = 0.01, ..., error.check = TRUE)
}
\arguments{
\item{x, y}{Time series. Multivariate series must have time spanning the rows and variables
spanning the columns.}

\item{gamma}{Positive regularization parameter, with lower values resulting in less smoothing.}

\item{...}{Currently ignored.}

\item{error.check}{Logical indicating whether the function should try to detect inconsistencies
and give more informative errors messages. Also used internally to avoid repeating checks.}
}
\value{
The Soft DTW distance.
}
\description{
Soft-DTW distance measure as proposed in Cuturi and Blondel (2017).
}
\details{
Unlike other distances, soft-DTW can return negative values, and \code{sdtw(x, x)} is not always equal
to zero. Like DTW, soft-DTW does not fulfill the triangle inequality, but it is always symmetric.
}
\section{Proxy version}{


The version registered with \code{\link[proxy]{dist}} is custom (\code{loop = FALSE} in
\code{\link[proxy]{pr_DB}}). The custom function handles multi-threaded parallelization
directly (with \code{\link[RcppParallel:RcppParallel-package]{RcppParallel}}). It uses all
available threads by default (see
\code{\link[RcppParallel:defaultNumThreads]{RcppParallel::defaultNumThreads()}}), but this can
be changed by the user with
\code{\link[RcppParallel:setThreadOptions]{RcppParallel::setThreadOptions()}}.

An exception to the above is when it is called within a \code{\link[foreach:foreach]{foreach}}
parallel loop \strong{made by dtwclust}. If the parallel workers do not have the number of
threads explicitly specified, this function will default to 1 thread per worker. See the
parallelization vignette for more information (\code{browseVignettes("dtwclust")}).



It also includes symmetric optimizations to calculate only half a distance matrix when
appropriate---only one list of series should be provided in \code{x}. If you want to avoid this
optimization, call \code{\link[proxy]{dist}} by giving the same list of series in both \code{x}
and \code{y}.
}

\references{
Cuturi, M., & Blondel, M. (2017). Soft-DTW: a Differentiable Loss Function for Time-Series. arXiv
preprint arXiv:1703.01541.
}
