% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-twdtwAssessment.R, R/methods.R
\docType{methods}
\name{twdtwAssessment-class}
\alias{twdtwAssessment-class}
\alias{twdtwAssessment}
\alias{show,twdtwAssessment-method}
\title{class "twdtwAssessment"}
\usage{
\S4method{show}{twdtwAssessment}(object)
}
\arguments{
\item{object}{an object of class twdtwAssessment.}
}
\description{
This class stores the map assessment metrics.
}
\details{
If the twdtwRaster is unprojected (longitude/latitude) the estimated area is sum of the approximate 
surface area in km2 of each cell (pixel). If the twdtwRaster is projected the estimated area is calculated 
using the the pixel resolution in the map unit.
}
\section{Slots }{

\describe{
 \item{\code{accuracySummary}:}{Overall Accuracy, User's Accuracy, Produce's Accuracy, 
 Error Matrix (confusion matrix), and Estimated Area, considering all time periods.}
 \item{\code{accuracyByPeriod}:}{Overall Accuracy, User's Accuracy, Produce's Accuracy, 
 Error Matrix (confusion matrix), and Estimated Area, for each time periods independently 
 from each other.}
 \item{\code{data}:}{A \code{\link[sp]{SpatialPointsDataFrame}} with sample ID, period,
 date from, date to, reference labels, predicted labels, and TWDTW distance.}
 \item{\code{map}:}{A \code{\link[dtwSat]{twdtwRaster}} with the raster maps.}
}
}

\seealso{
\code{\link[dtwSat]{twdtwClassify}},  
\code{\link[dtwSat]{twdtwAssess}}, and
\code{\link[dtwSat]{twdtwXtable}}.
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
