% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-time.R
\name{dtt_date_time}
\alias{dtt_date_time}
\alias{dtt_date_time.integer}
\alias{dtt_date_time.double}
\alias{dtt_date_time.character}
\alias{dtt_date_time.Date}
\alias{dtt_date_time.POSIXct}
\alias{dtt_date_time.hms}
\title{Date Time}
\usage{
dtt_date_time(x, ...)

\method{dtt_date_time}{integer}(x, tz = dtt_default_tz(), ...)

\method{dtt_date_time}{double}(x, tz = dtt_default_tz(), ...)

\method{dtt_date_time}{character}(x, tz = dtt_default_tz(), ...)

\method{dtt_date_time}{Date}(x, time = hms::as.hms("00:00:00"), tz = dtt_default_tz(), ...)

\method{dtt_date_time}{POSIXct}(x, tz = dtt_tz(x), ...)

\method{dtt_date_time}{hms}(x, date = dtt_date("1970-01-01"), tz = dtt_default_tz(), ...)
}
\arguments{
\item{x}{A vector.}

\item{...}{Unused.}

\item{tz}{A string of the time zone.}

\item{time}{A hms vector of the time.}

\item{date}{A Date vector of the date.}
}
\value{
A floored POSIXct vector.
}
\description{
Coerces vectors to floored POSIXct vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{integer}: Coerce integer vector to a floored POSIXct vector

\item \code{double}: Coerce double vector to a floored POSIXct vector

\item \code{character}: Coerce character vector to a floored POSIXct vector

\item \code{Date}: Coerce Date vector to a floored POSIXct vector

\item \code{POSIXct}: Coerce POSIXct vector to a floored POSIXct vector

\item \code{hms}: Coerce hms vector to a floored POSIXct vector
}}

\examples{
dtt_date_time(1L)
dtt_date_time(-1)
dtt_date_time(1, tz = "Etc/GMT+8")
dtt_date_time(as.Date("2000-01-02"))
dtt_date_time(as.Date("2000-01-02"), time = hms::as.hms("04:05:06"))
}
