% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot.R
\docType{data}
\name{std_size}
\alias{std_size}
\title{Standard paper sizes}
\format{
An object of class \code{list} of length 12.
}
\usage{
std_size
}
\description{
A list of standard paper sizes for outputting flowcharts or other dot
graphs. These include width and height dimensions in inches and can be
used as one way to specify the output size of a dot graph, including
flowcharts (see the \code{size} parameter of \code{\link[=flowchart]{flowchart()}}).
}
\details{
The sizes available are \code{A4}, \code{A5}, \code{full} (fits a portrait A4 with margins), \code{half} (half an
A4 with margins), \code{third}, \code{two_third}, \code{quarter}, \code{sixth} (all with reference to
an A4 page with margins). There are 2 landscape sizes \code{A4_landscape} and \code{full_landscape} which
fit an A4 page with or without margins. There are also 2 slide dimensions,
to fit with standard presentation software dimensions.

This is just a convenience. Similar effects can be achieved by providing \code{width} and \code{height}
parameters to \code{\link[=flowchart]{flowchart()}} directly.
}
\keyword{datasets}
