% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabresul.R
\name{tabresul}
\alias{tabresul}
\title{Prepare a table of results}
\usage{
tabresul(x, singletonsOnly = FALSE, removeZeroes = FALSE)
}
\arguments{
\item{x}{A basic chance assignment (bca)}

\item{singletonsOnly}{= TRUE reduces the table of results to elementary events (singletons).}

\item{removeZeroes}{= TRUE removes subsets with 0 mass.}
}
\value{
A list of two elements: \itemize{
  \item mbp The table of focal elements with the addition of their associated mass, degree of belief, plausibility and the plausibility ratio.
  \item con The measure of conflict between subsets.
  }
}
\description{
This utility function is a more detailed version of the \code{belplau} function. Different tables of measures of belief, plausibility and of the plausibility ratio can be obtained, namely by removing subsets with zero mass if present, or by asking for singletons only.
}
\examples{
 
x <- bca(tt = matrix(c(0,1,1,1,1,0,1,1,1),nrow = 3,
byrow = TRUE), m = c(0.2,0.5, 0.3), 
cnames = c("a", "b", "c"), 
varnames = "x", idvar = 1)
y <- bca(tt = matrix(c(1,0,0,1,1,1),nrow = 2, 
byrow = TRUE), m = c(0.6, 0.4),  
cnames = c("a", "b", "c"), varnames = "y", idvar = 1)
xy <- dsrwon(x,y)
xyNorm <- nzdsr(xy)
tabresul(xyNorm) 
## print("Show all elementary events")
xy1 <- addTobca(nzdsr(dsrwon(x,y)), 
matrix(c(0,1,0,0,0,1), 
nrow = 2, byrow = TRUE))
tabresul(xy1)
## print("Remove focal elements with 0 mass")
tabresul(xy1, removeZeroes = TRUE)
print("Retain singletons only")
tabresul(xy1, singletonsOnly = TRUE)
}
\author{
Claude Boivin, Stat.ASSQ
}
