% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class.Constructors.R
\name{make.coverage}
\alias{make.coverage}
\title{Creates a Coverage.Grid object}
\usage{
make.coverage(
  region = make.region(),
  spacing = numeric(0),
  n.grid.points = 1000
)
}
\arguments{
\item{region}{the region name}

\item{spacing}{spacing to be used to create the coverage grid. If
spacing is specified then any value supplied for n.grid.points will
be ignored.}

\item{n.grid.points}{the desired number of grid points (note that
the exact number generated may differ slightly depending on the
shape of the study region).}
}
\value{
object of class Coverage.Grid
}
\description{
This creates an instance of the Coverage.Grid class.
}
\examples{
# Fast running example, please note to more accurately assess coverage
# the spacing should be reduced. Spacings of between 20 and 50 will allow
# a better assessment of coverage to be achieved.
region <- make.region()
cover <- make.coverage(region, spacing = 250)
plot(region, cover)
}
\author{
Laura Marshall
}
