% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsrTest.R
\name{dsrTest}
\alias{dsrTest}
\title{Tests and Confidence Intervals on Directly Standardized Rates}
\usage{
dsrTest(x, n, w, null.value = NULL, alternative = c("two.sided", "less",
  "greater"), conf.level = 0.95, mult = 1, method = c("gamma",
  "asymptotic", "dobson", "beta", "bootstrap"), control = list())
}
\arguments{
\item{x}{a vector of strata-specific counts.}

\item{n}{a vector of strata-specific time bases for counts.}

\item{w}{a vector of strata-specific weights (or standard populations).}

\item{null.value}{a null hypothesis value of the directly
rate, if NULL no test is done. If not NULL, provide in rate per mult.}

\item{alternative}{type of alternative hypothesis.}

\item{conf.level}{confidence level for the returned
confidence interval.}

\item{mult}{a factor to multiply the estimate and
confidence intervals by, to give rates per mult.}

\item{method}{Method used to perform the test and construct the
confidence interval. See details.}

\item{control}{list of arguments / type of modification used for
each method. See details and relevant \code{"xxxxControl"} documentation}
}
\value{
a list with class \code{"htest"} containing the following
components
\tabular{ll}{
\code{statistic} \tab number of strata or summands:
\code{k = length(x)} \cr
\code{parameter} \tab mult \cr
\code{p.value} \tab p-value, set to \code{NA`` if}null.value = NULL` \cr
\code{conf.int} \tab confidence interval on the true directly
standardized rate \cr
\code{estimate} \tab directly standardized rate \cr
\code{null.value} \tab null hypothesis value for the DSR \cr
\code{alternative} \tab alternative hypothesis type \cr
\code{method} \tab description of the method \cr
\code{data.name} \tab description of the data \cr
}
}
\description{
A number of methods have been proposed for calculating
confidence intervals for directly standardized rates. Ng et al (2008),
compare a number of methods, some of which are implemented here.
The default uses the Gamma method by Fay and Feuer (1997) and
implemented in \code{\link[asht]{wspoissonTest}}.
}
\details{
Four classes of method have been implemented here:

\tabular{ll}{
\code{"gamma"} \tab Calls \code{\link[asht]{wspoissonTest}}. By default
uses the Gamma Method proposed by Fay and Feuer (1997). Modifications
proposed by Tiwari et al (2006) and Fay and Kim (2017) also implemented -
see \code{\link{gammaControl}}. \cr
\code{"asymptotic"} \tab Using the normal approximation of the MLE or transformed
MLE distribition - see \code{\link{asymptoticControl}} \cr
\code{"dobson"}  \tab Uses the method proposed by Dobson et al (1991). Estimating
the confidence interval on the unweighted sum is done by calling
\code{\link[exactci]{poisson.exact}} - both the exact method and
a mid-p method are possible - see \link{dobsonControl}. \cr
\code{"beta"}  \tab  Methods based on the beta distribution by Tiwari et
al (2006) - see \link{betaControl}. \cr
\code{"bootstrap"} \tab Approximate Bootstrap method by Swift (1995).
P-values are estimated by solving for p.\cr
}

For each method there is a \code{control} function that will return a
of parameters that can be used to define sub-types of each of the
broad groups
}
\references{
Dobson, AJ, Kuulasmaa, K, Eberle, E and Scherer, J (1991)
'Confidence intervals for weighted sums of Poisson parameters',
\emph{Statistics in Medicine}, \strong{10}: 457--462.
\doi{doi:10.1002/sim.4780100317}

Swift, MB (1995). 'Simple confidence intervals for
standardized rates based on the approximate bootstrap method',
\emph{Statistics in Medicine}, \strong{14}, 1875--1888.
\doi{doi:10.1002/sim.4780141704}.

Fay & Feuer (1997). 'Confidence intervals for directly
standardized rates: a method based on the gamma distribution.
Statistics in Medicine*. \strong{16}: 791--801.
\url{https://doi.org/10.1002/(SICI)1097-0258(19970415)16:7<791::AID-SIM500>3.0.CO;2-\%23}

Tiwari, Clegg, & Zou (2006). 'Efficient interval estimation
for age-adjusted cancer rates.'
\emph{Statistical Methods in Medical Research} \strong{15}: 547--569.
\doi{doi:10.1177/0962280206070621}

Ng, Filardo, & Zheng (2008). 'Confidence interval estimating
procedures for standardized incidence rates.'
\emph{Computational Statistics and Data Analysis} \strong{52} 3501--3516.
\doi{doi:10.1016/j.csda.2007.11.004}
}
\seealso{
\code{\link[asht]{wspoissonTest}},
\code{\link[exactci]{poisson.exact}},
\code{\link{gammaControl}},
\code{\link{dobsonControl}},
\code{\link{asymptoticControl}},
\code{\link{betaControl}}
}
