% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{cur_time}
\alias{cur_time}
\title{Current time (in hh:mm or hh:mm:ss format).}
\usage{
cur_time(seconds = FALSE, as_string = TRUE, sep = ":")
}
\arguments{
\item{seconds}{Boolean: Show time with seconds?
Default: \code{seconds = FALSE}.}

\item{as_string}{Boolean: Return as character string? 
Default: \code{as_string = TRUE}. 
If \code{as_string = FALSE}, a "POSIXct" object is returned.}

\item{sep}{Character: Separator to use. 
Default: \code{sep = ":"}.}
}
\value{
A character string or object of class "POSIXct".
}
\description{
\code{cur_time} provides a satisficing version of 
\code{Sys.time()} that is sufficient for most purposes.
}
\details{
By default, \code{cur_time} returns a 
\code{Sys.time()} as a character string 
(in "%H:%M" or "%H:%M:%S" format) 
using current system settings. 
If \code{as_string = FALSE}, a "POSIXct" 
(calendar time) object is returned. 

For a time zone argument, 
see the \code{\link{what_time}} function, 
or the \code{now()} function of 
the \strong{lubridate} package.
}
\examples{
cur_time() 
cur_time(seconds = TRUE)
cur_time(sep = ".")

# return a "POSIXct" object:
t <- cur_time(as_string = FALSE)
format(t, "\%T \%Z")

}
\seealso{
\code{what_time()} function to print times with more options;  
\code{now()} function of the \strong{lubridate} package; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{change_time}()},
\code{\link{change_tz}()},
\code{\link{cur_date}()},
\code{\link{days_in_month}()},
\code{\link{diff_dates}()},
\code{\link{diff_times}()},
\code{\link{diff_tz}()},
\code{\link{is_leap_year}()},
\code{\link{what_date}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_wday}()},
\code{\link{what_week}()},
\code{\link{what_year}()},
\code{\link{zodiac}()}
}
\concept{date and time functions}
