% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multitrial_binary.R
\name{utility_multitrial_binary}
\alias{utility_multitrial_binary}
\alias{utility2_binary}
\alias{utility3_binary}
\alias{utility4_binary}
\title{Utility function for multitrial programs with binary distributed outcomes}
\usage{
utility2_binary(
  n2,
  RRgo,
  w,
  p0,
  p11,
  p12,
  in1,
  in2,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  b1,
  b2,
  b3,
  case,
  fixed
)

utility3_binary(
  n2,
  RRgo,
  w,
  p0,
  p11,
  p12,
  in1,
  in2,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  b1,
  b2,
  b3,
  case,
  fixed
)

utility4_binary(
  n2,
  RRgo,
  w,
  p0,
  p11,
  p12,
  in1,
  in2,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  b1,
  b2,
  b3,
  case,
  fixed
)
}
\arguments{
\item{n2}{total sample size for phase II; must be even number}

\item{RRgo}{threshold value for the go/no-go decision rule}

\item{w}{weight for mixture prior distribution}

\item{p0}{assumed true rate of control group}

\item{p11}{assumed true rate of treatment group}

\item{p12}{assumed true rate of treatment group}

\item{in1}{amount of information for \code{p11} in terms of sample size}

\item{in2}{amount of information for \code{p12} in terms of sample size}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}

\item{case}{choose case: "at least 1, 2 or 3 significant trials needed for approval"}

\item{fixed}{choose if true treatment effects are fixed or random}
}
\value{
The output of the functions \code{utility2_binary()}, \code{utility3_binary()} and \code{utility4_binary()} is the expected utility of the program when 2, 3 or 4 phase III trials are performed.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in further step maximized by the \code{optimal_multitrial_binary()} function.
}
\examples{
res <- utility2_binary(n2 = 50, RRgo = 0.8,  w = 0.3, 
                                 p0 = 0.6, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, alpha = 0.025, beta = 0.1,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 case = 2, fixed = TRUE)
          res <- utility3_binary(n2 = 50, RRgo = 0.8,  w = 0.3, 
                                 p0 = 0.6, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, alpha = 0.025, beta = 0.1,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 case = 2, fixed = TRUE)
         res <- utility4_binary(n2 = 50, RRgo = 0.8,  w = 0.3, 
                                 p0 = 0.6, p11 =  0.3, p12 = 0.5, 
                                 in1 = 300, in2 = 600, alpha = 0.025, beta = 0.1,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 case = 3, fixed = TRUE)
}
\keyword{internal}
