% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuisance_fn.R
\name{fit_trt_spec_reg}
\alias{fit_trt_spec_reg}
\title{Helper function to fit a treatment specific outcome regression. 
If there are more than 2 observed levels of the outcome for the
specified treatment arm, then \code{polr} is used from the \code{MASS}
package. Otherwise logistic regression is used. In both cases, 
inverse probability of treatment weights are included in the regression. 
If there are levels of the outcome that are not observed in this treatment 
group, then 0's are added in. The function returns a matrix with named columns
corresponding to each outcome (ordered numerically). The entries 
represent the estimated covariate-conditional treatment-specific PMF.}
\usage{
fit_trt_spec_reg(
  trt_level,
  trt_spec_prob_est,
  out,
  treat,
  covar,
  out_levels,
  out_form = NULL,
  out_model,
  stratify,
  ...
)
}
\arguments{
\item{trt_level}{Which level of treatment to fit the proportional odds model for}

\item{trt_spec_prob_est}{A vector of estimates of Pr(\code{treat} = \code{trt_level} | \code{covar}).}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{treat}{A \code{numeric} vector containing treatment status. Missing
values are not allowed unless the corresponding entry in \code{out} is also missing. 
Only values of 0 or 1 are treated as actual treatment levels. Any other value is assumed 
to encode a value for which the outcome is missing and the corresponding outcome value is 
ignored.}

\item{covar}{A \code{data.frame} containing the covariates to include in the working
proportional odds model.}

\item{out_levels}{A \code{numeric} vector containing all ordered levels of the 
outcome.}

\item{out_form}{The right-hand side of a regression formula for the working proportional 
odds model. NOTE: THIS FORMULA MUST NOT SUPPRESS THE INTERCEPT.}

\item{out_model}{Which R function should be used to fit the proportional odds 
model. Options are \code{"polr"} (from the \code{MASS} package), 
"vglm" (from the \code{VGAM} package), or \code{"clm"} (from the \code{ordinal} package).}

\item{stratify}{Boolean indicating whether to use nonparametric maximum likelihood
(i.e., a stratified estimator). If \code{out_form = "1"}, then a covariate-unadjusted
estimate is computed.}

\item{...}{Other options (not used).}
}
\description{
Helper function to fit a treatment specific outcome regression. 
If there are more than 2 observed levels of the outcome for the
specified treatment arm, then \code{polr} is used from the \code{MASS}
package. Otherwise logistic regression is used. In both cases, 
inverse probability of treatment weights are included in the regression. 
If there are levels of the outcome that are not observed in this treatment 
group, then 0's are added in. The function returns a matrix with named columns
corresponding to each outcome (ordered numerically). The entries 
represent the estimated covariate-conditional treatment-specific PMF.
}
