\name{IM1xIPC81}
\docType{data}
\alias{IM1xIPC81}
\title{Dose-Response data for 1-methyl-3-alkylimidazolium tetrafluoroborates in IPC-81 cells}
\description{
  This is the raw data documenting the influence of the alkyl
  chain length in 3 position on the toxicity to the
  promyelocytic leukemia rat cell line IPC-81. The substances
  are named according to the UFT naming scheme of these
  substances. IM13 BF4 means 1-methyl-3-propylimidazolium
  tetrafluoroborate, IM14 BF4 means
  1-methyl-3-butylimidazolium tetrafluoroborate and IM1-10
  BF4 means 1-methyl-3-decylimidazolium tetrafluoroborate.
  This is a subset (only the BF4 anion) of the data
  shown in Figure 3 in Ranke et al. (2004).
}
\usage{data(IM1xIPC81)}
\format{
  A dataframe containing the data as required for the
  \code{\link{drfit}} function. An additional column contains
  the tested organism (name of the cell line).
}
\examples{
  rIM1xIPC81 <- drfit(IM1xIPC81, linlogit = TRUE, showED50 = TRUE, EDx = 10)

  rIM1xIPC81.drc <- drcfit(IM1xIPC81, linlogit = TRUE, showED50 = TRUE, EDx = 10)

  print(rIM1xIPC81,digits=4)
  print(rIM1xIPC81.drc,digits=4)
}
\source{
  Ranke J, Mlter K, Stock F, Bottin-Weber U, Poczobutt J,
  Hoffmann J, Ondruschka B, Filser J, Jastorff B (2004)
  Biological effects of imidazolium ionic liquids with varying
  chain lenghts in acute Vibrio fischeri and WST-1 cell
  viability assays. Ecotoxicology and Environmental Safety
  58(3) 396-404
}
\keyword{datasets}
