% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loggompertz.R
\name{loggompertz_gradient}
\alias{loggompertz_gradient}
\alias{loggompertz_hessian}
\alias{loggompertz_gradient_hessian}
\title{Log-Gompertz function gradient and Hessian}
\usage{
loggompertz_gradient(x, theta)

loggompertz_hessian(x, theta)

loggompertz_gradient_hessian(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the four parameters in the form
\code{c(alpha, delta, eta, phi)}.}
}
\value{
Gradient or Hessian evaluated at the specified point.
}
\description{
Evaluate at a particular set of parameters the gradient and Hessian of the
log-Gompertz function.
}
\details{
The log-Gompertz function \verb{f(x; theta)} is defined here as

\verb{f(x; theta) = alpha + delta exp(-(phi / x)^eta)}

where \code{x >= 0}, \code{theta = c(alpha, delta, eta, phi)}, \code{eta > 0}, and
\code{phi > 0}. By convention we set
\verb{f(0; theta) = lim_\{x -> 0\} f(x; theta) = alpha}.
}
