% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{diagnose}
\alias{diagnose}
\title{Get diagnostic metadata on a target.
\lifecycle{maturing}}
\usage{
diagnose(target = NULL, character_only = FALSE, path = NULL,
  search = NULL, cache = drake::drake_cache(path = path),
  verbose = 1L)
}
\arguments{
\item{target}{Name of the target of the error to get.
Can be a symbol if \code{character_only} is \code{FALSE},
must be a character if \code{character_only} is \code{TRUE}.}

\item{character_only}{Logical, whether \code{target} should be treated
as a character or a symbol.
Just like \code{character.only} in \code{\link[=library]{library()}}.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \code{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{verbose}{Deprecated on 2019-09-11.}
}
\value{
Either a character vector of target names or an object
of class \code{"error"}.
}
\description{
Diagnostics include errors, warnings,
messages, runtimes, and other context/metadata from when a
target was built or an import was processed.
If your target's last build succeeded,
then \code{diagnose(your_target)} has the most current information
from that build.
But if your target failed, then only
\code{diagnose(your_target)$error},
\code{diagnose(your_target)$warnings},
and \code{diagnose(your_target)$messages} correspond to the failure,
and all the other metadata correspond to the last build that completed
without an error.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
diagnose() # List all the targets with recorded error logs.
# Define a function doomed to failure.
f <- function() {
  stop("unusual error")
}
# Create a workflow plan doomed to failure.
bad_plan <- drake_plan(my_target = f())
# Running the project should generate an error
# when trying to build 'my_target'.
try(make(bad_plan), silent = FALSE)
failed() # List the failed targets from the last make() (my_target).
# List targets that failed at one point or another
# over the course of the project (my_target).
# drake keeps all the error logs.
diagnose()
# Get the error log, an object of class "error".
error <- diagnose(my_target)$error # See also warnings and messages.
str(error) # See what's inside the error log.
error$calls # View the traceback. (See the traceback() function).
})
}
}
\seealso{
\code{\link[=failed]{failed()}}, \code{\link[=progress]{progress()}},
\code{\link[=readd]{readd()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
