% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_plan.R
\name{transformations}
\alias{transformations}
\alias{map}
\alias{split}
\alias{cross}
\alias{combine}
\alias{group}
\title{Transformations in \code{drake_plan()}. \lifecycle{maturing}}
\arguments{
\item{...}{Grouping variables. New grouping variables must be
supplied with their names and values, existing grouping variables
can be given as symbols without any values assigned.
For dynamic branching, the entries in \code{...} must be unnamed symbols
with no values supplied, and they must be the names of targets.}

\item{.data}{A data frame of new grouping variables with
grouping variable names as column names and values as elements.}

\item{.names}{Literal character vector of names for the targets.
Must be the same length as the targets generated.}

\item{.id}{Symbol or vector of symbols naming grouping variables
to incorporate into target names. Useful for creating short target
names. Set \code{.id = FALSE} to use integer indices as target name suffixes.}

\item{.tag_in}{A symbol or vector of symbols. Tags assign targets
to grouping variables. Use \code{.tag_in} to assign \emph{untransformed}
targets to grouping variables.}

\item{.tag_out}{Just like \code{.tag_in}, except that \code{.tag_out}
assigns \emph{transformed} targets to grouping variables.}

\item{slice}{Number of slices into which \code{split()} partitions the data.}

\item{margin}{Which margin to take the slices in \code{split()}. Same meaning
as the \code{MARGIN} argument of \code{apply()}.}

\item{drop}{Logical, whether to drop a dimension if its length is 1.
Same meaning as \code{mtcars[, 1L, drop = TRUE]} versus
\code{mtcars[, 1L, drop = TRUE]}.}

\item{.by}{Symbol or vector of symbols of grouping variables.
\code{combine()} aggregates/groups targets by the grouping variables in \code{.by}.
For dynamic branching, \code{.by} can only take one variable at a time,
and that variable must be a vector. Ideally, it should take
little space in memory.}

\item{.trace}{Symbol or vector of symbols for the dynamic trace.
The dynamic trace allows you to keep track of the values of
dynamic dependencies are associated with individual sub-targets.
For \code{combine()}, \code{.trace} must either be empty or the same as the
variable given for \code{.by}.
See \code{\link[=get_trace]{get_trace()}} and \code{\link[=read_trace]{read_trace()}} for examples and other details.}
}
\description{
In \code{\link[=drake_plan]{drake_plan()}}, you can define whole batches
of targets with transformations such as
\code{map()}, \code{split()}, \code{cross()}, and \code{combine()}.
}
\details{
For details, see
\url{https://books.ropensci.org/drake/plans.html#large-plans}.
}
\section{Transformations}{

\code{drake} has special syntax for generating large plans.
Your code will look something like
\verb{drake_plan(y = target(f(x), transform = map(x = c(1, 2, 3)))}
You can read about this interface at
\url{https://books.ropensci.org/drake/plans.html#large-plans}. # nolint
}

\section{Static branching}{

In static branching, you define batches of targets
based on information you know in advance.
Overall usage looks like
\verb{drake_plan(<x> = target(<...>, transform = <call>)},
where
\itemize{
\item \verb{<x>} is the name of the target or group of targets.
\item \verb{<...>} is optional arguments to \code{\link[=target]{target()}}.
\item \verb{<call>} is a call to one of the transformation functions.
}

Transformation function usage:
\itemize{
\item \code{map(..., .data, .names, .id, .tag_in, .tag_out)}
\item \code{split(..., slices, margin = 1L, drop = FALSE, .names, .tag_in, .tag_out)} # nolint
\item \code{cross(..., .data, .names, .id, .tag_in, .tag_out)}
\item \code{combine(..., .by, .names, .id, .tag_in, .tag_out)}
}
}

\section{Dynamic branching}{

\itemize{
\item \code{map(..., .trace)}
\item \code{cross(..., .trace)}
\item \code{group(..., .by, .trace)}
}

\code{map()} and \code{cross()} create dynamic sub-targets from the variables
supplied to the dots. As with static branching, the variables
supplied to \code{map()} must all have equal length.
\code{group(f(data), .by = x)} makes new dynamic
sub-targets from \code{data}. Here, \code{data} can be either static or dynamic.
If \code{data} is dynamic, \code{group()} aggregates existing sub-targets.
If \code{data} is static, \code{group()} splits \code{data} into multiple
subsets based on the groupings from \code{.by}.

Differences from static branching:
\itemize{
\item \code{...} must contain \emph{unnamed} symbols with no values supplied,
and they must be the names of targets.
\item Arguments \code{.id}, \code{.tag_in}, and \code{.tag_out} no longer apply.
}
}

\examples{
# Static branching
models <- c("glm", "hierarchical")
plan <- drake_plan(
  data = target(
    get_data(x),
    transform = map(x = c("simulated", "survey"))
  ),
  analysis = target(
    analyze_data(data, model),
    transform = cross(data, model = !!models, .id = c(x, model))
  ),
  summary = target(
    summarize_analysis(analysis),
    transform = map(analysis, .id = c(x, model))
  ),
  results = target(
    bind_rows(summary),
    transform = combine(summary, .by = data)
  )
)
plan
if (requireNamespace("styler")) {
  print(drake_plan_source(plan))
}
# Static splitting
plan <- drake_plan(
  analysis = target(
    analyze(data),
    transform = split(data, slices = 3L, margin = 1L, drop = FALSE)
  )
)
print(plan)
if (requireNamespace("styler", quietly = TRUE)) {
  print(drake_plan_source(plan))
}
# Static tags:
drake_plan(
  x = target(
    command,
    transform = map(y = c(1, 2), .tag_in = from, .tag_out = c(to, out))
  ),
  trace = TRUE
)
plan <- drake_plan(
  survey = target(
    survey_data(x),
    transform = map(x = c(1, 2), .tag_in = source, .tag_out = dataset)
  ),
  download = target(
    download_data(),
    transform = map(y = c(5, 6), .tag_in = source, .tag_out = dataset)
  ),
  analysis = target(
    analyze(dataset),
    transform = map(dataset)
  ),
  results = target(
    bind_rows(analysis),
    transform = combine(analysis, .by = source)
  )
)
plan
if (requireNamespace("styler", quietly = TRUE)) {
  print(drake_plan_source(plan))
}
}
