% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_times.R
\name{build_times}
\alias{build_times}
\title{List the time it took to build each target/import.}
\usage{
build_times(..., path = getwd(), search = TRUE, digits = 3,
  cache = get_cache(path = path, search = search, verbose = verbose),
  targets_only = FALSE, verbose = drake::default_verbose(), jobs = 1,
  type = c("build", "command"))
}
\arguments{
\item{...}{targets to load from the cache: as names (symbols) or
character strings. If the \code{tidyselect} package is installed,
you can also supply \code{dplyr}-style \code{tidyselect}
commands such as \code{starts_with()}, \code{ends_with()}, and \code{one_of()}.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{digits}{How many digits to round the times to.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{targets_only}{logical, whether to only return the
build times of the targets (exclude the imports).}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: also print checks and cache info.
\item \code{3}: also print any potentially missing items.
\item \code{4}: also print imports and writes to the cache.
}}

\item{jobs}{number of jobs/workers for parallel processing}

\item{type}{Type of time you want: either \code{"build"}
for the full build time including the time it took to
store the target, or \code{"command"} for the time it took
just to run the command.}
}
\value{
A data frame of times, each from \code{\link[=system.time]{system.time()}}.
}
\description{
Listed times do not include the amount of time
spent loading and saving objects! See the \code{type}
argument for different versions of the build time.
(You can choose whether to take storage time into account.)
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
# Show the build times for the mtcars example.
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Build all the targets.
build_times() # Show how long it took to build each target.
})
}
}
\seealso{
\code{\link[=built]{built()}}
}
