% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{recover_cache}
\alias{recover_cache}
\title{Load an existing drake files system cache if it exists
or create a new one otherwise.}
\usage{
recover_cache(path = drake::default_cache_path(),
  short_hash_algo = drake::default_short_hash_algo(),
  long_hash_algo = drake::default_long_hash_algo(), force = FALSE,
  verbose = drake::default_verbose(), fetch_cache = NULL,
  console_log_file = NULL)
}
\arguments{
\item{path}{file path of the cache}

\item{short_hash_algo}{short hash algorithm for the cache.
See \code{\link[=default_short_hash_algo]{default_short_hash_algo()}} and
\code{\link[=make]{make()}}}

\item{long_hash_algo}{long hash algorithm for the cache.
See \code{\link[=default_long_hash_algo]{default_long_hash_algo()}} and
\code{\link[=make]{make()}}}

\item{force}{logical, whether to load the cache
despite any back compatibility issues with the
running version of drake.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{+ checks and cache info.}
\item{3:}{+ any potentially missing items.}
\item{4:}{+ imports and writes to the cache.}
}}

\item{fetch_cache}{character vector containing lines of code.
The purpose of this code is to fetch the \code{storr} cache
with a command like \code{\link[=storr_rds]{storr_rds()}} or \code{\link[=storr_dbi]{storr_dbi()}},
but customized. This feature is experimental. It will turn out
to be necessary if you are using both custom non-RDS caches
and distributed parallelism (\code{parallelism = "future_lapply"}
or \code{"Makefile"}) because the distributed R sessions
need to know how to load the cache.}

\item{console_log_file}{character scalar or \code{NULL}.
If \code{NULL}, console output will be printed
to the R console using \code{message()}.
Otherwise, \code{console_log_file} should be the name of a flat file.
Console output will be appended to that file.}
}
\value{
A drake/storr cache.
}
\description{
Does not work with
in-memory caches such as \code{\link[=storr_environment]{storr_environment()}}.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
clean(destroy = TRUE)
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build all the targets.
x <- recover_cache(".drake") # Recover the project's storr cache.
})
}
}
\seealso{
\code{\link[=new_cache]{new_cache()}}, \code{\link[=this_cache]{this_cache()}},
\code{\link[=get_cache]{get_cache()}}
}
