% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{build_drake_graph}
\alias{build_drake_graph}
\title{Create the \code{igraph} dependency network of your project.}
\usage{
build_drake_graph(plan = drake_plan(),
  targets = drake::possible_targets(plan), envir = parent.frame(),
  verbose = 1, jobs = 1)
}
\arguments{
\item{plan}{workflow plan data frame, same as for function
\code{\link{make}()}.}

\item{targets}{names of targets to build, same as for function
\code{\link{make}()}.}

\item{envir}{environment to import from, same as for function
\code{\link{make}()}.}

\item{verbose}{logical, whether to output messages to the console.}

\item{jobs}{number of jobs to accelerate the construction
of the dependency graph. A light \code{mclapply}-based
parallelism is used if your operating system is not Windows.}
}
\value{
An igraph object representing
the workflow plan dependency network.
}
\description{
This function returns an igraph object representing how
the targets in your workflow plan data frame
depend on each other.
(\code{help(package = "igraph")}). To plot the graph, call
to \code{\link{plot.igraph}()} on your graph, or just use
\code{\link{vis_drake_graph}()} from the start.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_basic_example() # Get the code with drake_example("basic").
# Make the igraph network connecting all the targets and imports.
g <- build_drake_graph(my_plan)
class(g) # "igraph"
})
}
}
\seealso{
\code{\link{vis_drake_graph}}
}
