% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotgraph.R
\name{render_graph}
\alias{render_graph}
\title{Function \code{render_graph}}
\usage{
render_graph(graph, file = character(0), layout = "layout_with_sugiyama",
  direction = "LR", navigationButtons = TRUE, hover = TRUE,
  selfcontained = FALSE, ...)
}
\arguments{
\item{graph}{list of data frames generated by \code{\link{dataframes_graph}()}.
There should be 3 data frames: \code{nodes}, \code{edges}, 
and \code{legend_nodes}.}

\item{file}{Name of HTML file to save the graph. If \code{NULL} or \code{character(0)},
no file is saved and the graph is rendered and displayed within R.}

\item{layout}{name of an igraph layout to use, such as "layout_with_sugiyama"
or "layout_as_tree". Be careful with "layout_as_tree": the graph is a directed 
acyclic graph, but not necessarily a tree.}

\item{direction}{an argument to \code{visNetwork::visHierarchicalLayout()}
indicating the direction of the graph. Options include "LR", "RL", "DU", and "UD".
At the time of writing this, the letters must be capitalized, 
but this may not always be the case ;) in the future.}

\item{navigationButtons}{logical, whether to add navigation buttons with 
\code{visNetwork::visInteraction(navigationButtons = TRUE)}}

\item{hover}{logical, whether to show the command that generated the target
when you hover over a node with the mouse. For imports, the label does not
change with hovering.}

\item{selfcontained}{logical, whether to save the \code{file} as a self-contained
HTML file (with external resources base64 encoded) or a file with
external resources placed in an adjacent directory. If \code{TRUE},
pandoc is required.}

\item{...}{arguments passed to \code{visNetwork()}.}
}
\description{
render a graph from the data frames 
generated by \code{\link{dataframes_graph}()}
}
\examples{
\dontrun{
load_basic_example()
graph = dataframes_graph(my_plan)
render_graph(graph, width = "100\%") # The width is passed to visNetwork().
}
}
