% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_outliers.R
\name{get_outliers}
\alias{get_outliers}
\title{Extract outliers from a scluminex object}
\usage{
get_outliers(x, out.limit = 2.5)
}
\arguments{
\item{x}{a \code{scluminex} object}

\item{out.limit}{cutoff point for outliers}
}
\value{
A \code{data.frame} with samples whose standardized
residual is greater than \code{out.limit}.
}
\description{
This function extracts outliers based on a residuals cutoff from
\code{scluminex} object.
}
\details{
The residuals are the standardized ones
for \code{\link{nls}} models.
}
\examples{
# Load data and estimate models
data(ecdata)
data(mfidata)

dat <- mfidata[mfidata$plate=="plate_1" & mfidata$analyte=="FGF",]

# Select data and fit models
sdf <- data_selection(dat, ecdata)[[1]]
igmodels <- scluminex("plate_1",sdf$standard, sdf$background,
                      lfct=c("SSl4", "SSl5"),
                      bkg="ignore",
                      fmfi="mfi",
                      verbose=FALSE)

# Extract outliers > abs(2.5)
get_outliers(igmodels, out.limit=2.5)

# Extract outliers > abs(1.5)
get_outliers(igmodels, out.limit=1.5)

# Extract outliers > abs(1)
get_outliers(igmodels, out.limit=1)
}

