% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpm.R
\name{get_wide_data}
\alias{get_wide_data}
\title{Retrieve wide-format data from fitted dpm model}
\usage{
get_wide_data(model)
}
\arguments{
\item{model}{A \code{dpm} object.}
}
\value{
A \code{data.frame} with input data transformed from "long" to "wide"
format, with just one row per person/entity. Internally, this is
generated by calling \code{panelr::widen_panel()} after some
preprocessing.
}
\description{
This helper function provides a simple way to retrieve the
widened data from a fitted \code{\link[=dpm]{dpm()}} object.
}
\examples{

data("WageData", package = "panelr")
wages <- panel_data(WageData, id = id, wave = t)
fit <- dpm(wks ~ pre(lag(union)) + lag(lwage), data = wages)
get_wide_data(fit)

}
