% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-collect.r
\name{compute}
\alias{compute}
\alias{collect}
\alias{collapse}
\title{Force computation of a database query}
\usage{
compute(x, name = random_table_name(), ...)

collect(x, ...)

collapse(x, ...)
}
\arguments{
\item{x}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for more
details.}

\item{name}{Name of temporary table on database.}

\item{...}{Other arguments passed on to methods}
}
\description{
\code{compute()} stores results in a remote temporary table.
\code{collect()} retrieves data into a local tibble.
\code{collapse()} is slightly different: it doesn't force computation, but
instead forces generation of the SQL query. This is sometimes needed to work
around bugs in dplyr's SQL generation.

All functions preserve grouping and ordering.
}
\section{Methods}{

These functions are \strong{generics}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

Methods available in currently loaded packages:
\itemize{
\item \code{compute()}: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("compute")}
\item \code{collect()}: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("collect")}
\item \code{collapse()}: \Sexpr[stage=render,results=rd]{dplyr:::methods_rd("collapse")}
}
}

\examples{
if (require(dbplyr)) {
  mtcars2 <- src_memdb() \%>\%
    copy_to(mtcars, name = "mtcars2-cc", overwrite = TRUE)

  remote <- mtcars2 \%>\%
    filter(cyl == 8) \%>\%
    select(mpg:drat)

  # Compute query and save in remote table
  compute(remote)

  # Compute query bring back to this session
  collect(remote)

  # Creates a fresh query based on the generated SQL
  collapse(remote)
}
}
\seealso{
\code{\link[=copy_to]{copy_to()}}, the opposite of \code{collect()}: it takes a local data
frame and uploads it to the remote source.
}
