% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise-arrange.R
\name{arrange_all}
\alias{arrange_all}
\alias{arrange_at}
\alias{arrange_if}
\title{Arrange rows by a selection of variables}
\usage{
arrange_all(.tbl, .funs = list(), ...)

arrange_at(.tbl, .vars, .funs = list(), ...)

arrange_if(.tbl, .predicate, .funs = list(), ...)
}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.funs}{List of function calls generated by \code{\link[=funs]{funs()}}, or a
character vector of function names, or simply a function.

Bare formulas are passed to \code{\link[rlang:as_function]{rlang::as_function()}} to create
purrr-style lambda functions. Note that these lambda prevent
hybrid evaluation from happening and it is thus more efficient to
supply functions like \code{mean()} directly rather than in a
lambda-formula.}

\item{...}{Additional arguments for the function calls in
\code{.funs}. These are evaluated only once, with \link[rlang:tidy-dots]{tidy
dots} support.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}
}
\description{
These \link{scoped} variants of \code{\link[=arrange]{arrange()}} sort a data frame by a
selection of variables. Like \code{\link[=arrange]{arrange()}}, you can modify the
variables before ordering with \code{\link[=funs]{funs()}}.
}
\examples{
df <- as_tibble(mtcars)
df
arrange_all(df)

# You can supply a function that will be applied before taking the
# ordering of the variables. The variables of the sorted tibble
# keep their original values.
arrange_all(df, desc)
arrange_all(df, funs(desc(.)))
}
