% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dbi-s3.r
\name{backend_db}
\alias{backend_db}
\alias{db_analyze}
\alias{db_begin}
\alias{db_commit}
\alias{db_create_index}
\alias{db_create_table}
\alias{db_data_type}
\alias{db_drop_table}
\alias{db_explain}
\alias{db_has_table}
\alias{db_insert_into}
\alias{db_list_tables}
\alias{db_query_fields}
\alias{db_query_rows}
\alias{db_rollback}
\alias{db_save_query}
\title{Database generics.}
\usage{
db_list_tables(con)

db_has_table(con, table)

db_data_type(con, fields)

db_save_query(con, sql, name, temporary = TRUE, ...)

db_begin(con, ...)

db_commit(con, ...)

db_rollback(con, ...)

db_create_table(con, table, types, temporary = FALSE, ...)

db_insert_into(con, table, values, ...)

db_create_index(con, table, columns, name = NULL, ...)

db_drop_table(con, table, force = FALSE, ...)

db_analyze(con, table, ...)

db_explain(con, sql, ...)

db_query_fields(con, sql, ...)

db_query_rows(con, sql, ...)
}
\arguments{
\item{con}{A database connection.}

\item{table}{A string, the table name.}

\item{fields}{A list of fields, as in a data frame.}
}
\value{
A logical value indicating success. Most failures should generate
 an error.
}
\description{
These generics execute actions on the database. All generics have a method
for \code{DBIConnection} which typically just call the standard DBI S4
method.
}
\section{copy_to}{

Currently, the only user of \code{sql_begin()}, \code{sql_commit()},
\code{sql_rollback()}, \code{sql_create_table()}, \code{sql_insert_into()},
\code{sql_create_indexes()}, \code{sql_drop_table()} and
\code{sql_analyze()}. If you find yourself overriding many of these
functions it may suggest that you should just override \code{\link{copy_to}}
instead.
}
\keyword{internal}

