% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/bind_dpcr.R
\docType{methods}
\name{bind_dpcr-methods}
\alias{bind_dpcr}
\alias{bind_dpcr,adpcr}
\alias{bind_dpcr,adpcr-method}
\alias{bind_dpcr,ddpcr}
\alias{bind_dpcr,ddpcr-method}
\alias{bind_dpcr,list}
\alias{bind_dpcr,list-method}
\alias{bind_dpcr-methods}
\title{Bind dpcr objects}
\usage{
bind_dpcr(input, ...)
}
\arguments{
\item{input}{an object of class \code{\linkS4class{adpcr}} or
\code{\linkS4class{ddpcr}} or a list.}

\item{...}{objects of class \code{\linkS4class{adpcr}} or
\code{\linkS4class{ddpcr}}. See Details. If \code{input} is a list, ignored.}
}
\value{
An object of class \code{\linkS4class{adpcr}} or
\code{\linkS4class{ddpcr}}, depending on the input.
}
\description{
A convinient wrapper around \code{\link[base]{cbind}} and
\code{\link[base]{rbind}} tailored specially for binding multiple objects
containing results from digital PCR experiments.
}
\details{
In case of \code{adpcr} or \code{ddpcr} objects, \code{bind_dpcr} can works
analogously to \code{\link[base]{cbind}}), but without recycling. In case on
unequal length, shorter objects will be filled in with additional \code{NA}
values. The original length is always preserved in \code{n} slot.

\code{bind_dpcr} automatically names binded experiments using format
\code{x}.\code{y}, where \code{x} is number of object passed to function and
\code{y} is a number of experiment in a given object.
}
\note{
Because \code{bind_dpcr} calls \code{\link[base]{do.call}} function,
binding together at the same time more than 500 objects can lead to
'stack overflow' error.
}
\examples{
bigger_array <- sim_adpcr(400, 765, 1000, pos_sums = FALSE, n_panels = 5)
smaller_array <- sim_adpcr(100, 700, 1000, pos_sums = FALSE, n_panels = 3)
bound_arrays <- bind_dpcr(bigger_array, smaller_array)

smaller_droplet <- sim_ddpcr(m = 7, n = 20, times = 5, n_exp = 2)
bigger_droplet <- sim_ddpcr(m = 15, n = 25, times = 5, n_exp = 4)
biggest_droplet <- sim_ddpcr(m = 15, n = 35, times = 5, n_exp = 1)
bound_droplets <- bind_dpcr(smaller_droplet, bigger_droplet, biggest_droplet)
}
\author{
Michal Burdukiewicz
}
\seealso{
Opposite function: \code{\link{extract_dpcr}}
}
\keyword{manip}

