% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_plot.R
\name{door_cumulative_forestplot}
\alias{door_cumulative_forestplot}
\title{Generate cumulative DOOR forest plot}
\usage{
door_cumulative_forestplot(
  y1 = NULL,
  y2 = NULL,
  n1 = NULL,
  n2 = NULL,
  data_type = c("freq", "prop"),
  summary_obj = NULL,
  conf_level = 0.95,
  ci_method = c("halperin", "ps_h", "tanh")
)
}
\arguments{
\item{y1, y2}{Numeric vectors of DOOR proportion or frequency distribution for group 1, group 2.
The entries should be ordered from most desirable to least desirable}

\item{n1, n2}{Sample sizes of group 1, group 2; must be specified if method = "prop"}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
when using y1 and y2}

\item{summary_obj}{An object returned by \code{individual_to_summary()}; Alternative
input for y1 and y2}

\item{conf_level}{confidence level}

\item{ci_method}{methods for calculating confidence interval}
}
\value{
a forestplot object
}
\description{
Generate cumulative DOOR forest plot
}
\examples{
y1 = c(60, 30, 10)
y2 = c(50, 40, 10)
door_cumulative_forestplot(y1, y2)
}
