% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-conversion.R
\name{dodgr_to_igraph}
\alias{dodgr_to_igraph}
\title{Convert a \code{dodgr} graph to an \pkg{igraph}.}
\usage{
dodgr_to_igraph(graph, weight_column = "d")
}
\arguments{
\item{graph}{A \code{dodgr} graph}

\item{weight_column}{The column of the \code{dodgr} network to use as the edge
weights in the \code{igraph} representation.}
}
\value{
The \code{igraph} equivalent of the input. Note that this will \emph{not}
be a dual-weighted graph.
}
\description{
Convert a \code{dodgr} graph to an \pkg{igraph}.
}
\examples{
graph <- weight_streetnet (hampi)
graphi <- dodgr_to_igraph (graph)
}
\seealso{
\link{igraph_to_dodgr}

Other conversion: 
\code{\link{dodgr_deduplicate_graph}()},
\code{\link{dodgr_to_sfc}()},
\code{\link{dodgr_to_sf}()},
\code{\link{dodgr_to_tidygraph}()},
\code{\link{igraph_to_dodgr}()}
}
\concept{conversion}
