% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-heaps.R
\name{compare_heaps}
\alias{compare_heaps}
\title{compare_heaps}
\usage{
compare_heaps(graph, nverts = 100, replications = 2)
}
\arguments{
\item{graph}{\code{data.frame} object representing the network graph (or a
sub-sample selected with code{dodgr_sample})}

\item{nverts}{Number of vertices used to generate random sub-graph. If a
non-numeric value is given, the whole graph will be used.}

\item{replications}{Number of replications to be used in comparison}
}
\value{
Result of \code{bench::mark} comparison.
}
\description{
Perform timing comparison between different kinds of heaps as well as with
equivalent \code{igraph} routine \code{distances}. To do this, a random
sub-graph containing a defined number of vertices is first selected.
Alternatively, this random sub-graph can be pre-generated with the
\code{dodgr_sample} function and passed directly.
}
\note{
\pkg{igraph} caches intermediate results of graph processing, so
the \pkg{igraph} comparisons will be faster on subsequent runs. To obtain
fair comparisons, run only once or re-start the current R session.
}
\examples{
graph <- weight_streetnet (hampi)
\dontrun{
compare_heaps (graph, nverts = 1000, replications = 1)
}
}
\seealso{
Other misc: 
\code{\link{dodgr_flowmap}()},
\code{\link{dodgr_full_cycles}()},
\code{\link{dodgr_fundamental_cycles}()},
\code{\link{dodgr_insert_vertex}()},
\code{\link{dodgr_sample}()},
\code{\link{dodgr_sflines_to_poly}()},
\code{\link{dodgr_vertices}()},
\code{\link{merge_directed_graph}()},
\code{\link{summary.dodgr_dists_categorical}()},
\code{\link{write_dodgr_wt_profile}()}
}
\concept{misc}
