% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-functions.R
\name{dodgr_insert_vertex}
\alias{dodgr_insert_vertex}
\title{dodgr_insert_vertex}
\usage{
dodgr_insert_vertex(graph, v1, v2, x = NULL, y = NULL)
}
\arguments{
\item{graph}{A flat table of graph edges. Must contain columns labelled
\code{from} and \code{to}, or \code{start} and \code{stop}. May also contain
similarly labelled columns of spatial coordinates (for example
\code{from_x}) or \code{stop_lon}).}

\item{v1}{Vertex defining start of graph edge along which new vertex is to be
inserted}

\item{v2}{Vertex defining end of graph edge along which new vertex is to be
inserted (order of \code{v1} and \code{v2} is not important).}

\item{x}{The \code{x}-coordinate of new vertex. If not specified, vertex is
created half-way between \code{v1} and \code{v2}.}

\item{y}{The \code{y}-coordinate of new vertex. If not specified, vertex is
created half-way between \code{v1} and \code{v2}.}
}
\value{
A modified graph with specified edge between defined start and end
vertices split into two edges either side of new vertex.
}
\description{
Insert a new node or vertex into a network
}
\examples{
graph <- weight_streetnet (hampi)
e1 <- sample (nrow (graph), 1)
v1 <- graph$from_id [e1]
v2 <- graph$to_id [e1]
# insert new vertex in the middle of that randomly-selected edge:
graph2 <- dodgr_insert_vertex (graph, v1, v2)
nrow (graph); nrow (graph2) # new edges added to graph2
}
\seealso{
Other misc: 
\code{\link{compare_heaps}()},
\code{\link{dodgr_flowmap}()},
\code{\link{dodgr_full_cycles}()},
\code{\link{dodgr_fundamental_cycles}()},
\code{\link{dodgr_sample}()},
\code{\link{dodgr_sflines_to_poly}()},
\code{\link{dodgr_vertices}()},
\code{\link{match_points_to_graph}()},
\code{\link{match_pts_to_graph}()},
\code{\link{merge_directed_graph}()},
\code{\link{summary.dodgr_dists_categorical}()},
\code{\link{write_dodgr_wt_profile}()}
}
\concept{misc}
