% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{diagnose}
\alias{diagnose}
\title{Checks if a table is in its expected form}
\usage{
diagnose(X, exams = guess_exams(X))
}
\arguments{
\item{X}{Table to run tests on}

\item{exams}{Tests to be run on \code{X} (see \code{vignette("doctr_diagnose")}
for more information)}
}
\description{
Runs tests on a table to check if its variables pass
  certain standards and fit certain assumptions
  specified via \code{exams}
}
\details{
This function receives a table and a battery of exams
  that its variables should pass; if a variable doesn't
  pass any of these tests, comprehensive reports are
  created (you can access them with \code{issues()})
}
\examples{
\dontrun{
library(tidyverse)
  
# Running default diagnostics on a table
txhousing \%>\% diagnose() \%>\% issues()
  
# Running custom diagnostics on a table
exams <- guess_exams(txhousing)
exams$max_val[5] <- 2000000000
txhousing \%>\% diagnose(exams) \%>\% issues(verbose = TRUE)
}

}
