% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_gt.R
\name{apply_scale}
\alias{apply_scale}
\alias{apply_scale.default}
\alias{apply_scale.gt_tbl}
\alias{apply_scale.gt_group}
\title{Apply scaling to gt objects}
\usage{
apply_scale(x, fontsize, tbl_scale, tbl_stub_pct)

\method{apply_scale}{default}(x, fontsize, tbl_scale, tbl_stub_pct)

\method{apply_scale}{gt_tbl}(x, fontsize, tbl_scale, tbl_stub_pct)

\method{apply_scale}{gt_group}(x, fontsize, tbl_scale, tbl_stub_pct)
}
\arguments{
\item{x}{gt object}

\item{fontsize}{document font size}

\item{tbl_scale}{Boolean for whether or not to automatically scale table columns to fit display area. Defaults to TRUE. Note that this will overwrite scaling set in the table directly unless set to FALSE.}

\item{tbl_stub_pct}{percent of total width that should be dedicated to stub column(s). If more than 1 stub column then this is the total for both.}
}
\value{
scaled gt object
}
\description{
Apply scaling to gt objects
}
\examples{
gt <- gt::exibble |>
gt::gt()

apply_scale(gt, fontsize = 10, tbl_scale = FALSE, tbl_stub_pct = "20\%")
}
\keyword{internal}
